//
// Inherit from.
//
local function Inherit( dest, src )
	// copy everything from src to dest, unless it already exists.
	local k, v;
	for k, v in pairs( src ) do
		// value, copy.
		if( type( v ) ~= "table" ) then
			// doesn't exist?
			if( dest[ k ] == nil ) then
				dest[ k ] = v;
				
			end
		
		// we are a table.	
		else
			// doesn't exist?
			if( k != "__ctor" && k != "__index" and dest[ k ] == nil ) then
				// create a new table to copy into.
				local newtable = {};
				
				// store
				dest[ k ] = newtable;
				
				// recurse.
				Inherit( dest[ k ], v );
				
			end

		end
	
	end
end

//
// Call constructor all
//
local function CallAllConstructors( superclass, obj )	
	// has a ctor method?
	if( superclass.__ctor ) then
		// attempt to call it.
		superclass.__ctor( obj );
		
	end
	
	// has base classes?
	if( superclass.__baseclasses ) then
		// call those as well.
		local i;
		for i = 1, table.getn( superclass.__baseclasses ) do
			CallAllConstructors( superclass.__baseclasses[i], obj );
		
		end
	
	end
	
end



//
// OOP_Derive
//
function OOP_Derive( ... )
	// create the new class.
	local class = {
		__baseclasses = arg,
	};
	
	// inherit all the methods from the base classes.
	local i;
	for i = 1, table.getn( arg ) do
		if( arg[i] ) then Inherit( class, arg[i] ); end
	
	end
	
	//
	class.__index = class;
	
	// create method.
	function class:create( )
		// create an object
		local obj = {};
		setmetatable( obj, class );
	
		// call the __ctor method for each base class.
		local i;
		for i = 1, table.getn( arg ) do
			local superclass = arg[i];
			
			// call the constructor methods for those.
			CallAllConstructors( superclass, obj );
		
		end
		
		// call my constructor
		if( obj.__ctor ) then
			// attempt to call it.
			obj:__ctor();

		end
		
		// all done!
		return obj;
		
	end
	
	// super method.
	function class:super( base )
		base = base or 1;
		return self.__baseclasses[ base ];
		
	end
	
	// all done!
	return class;

end

//
// The object indexing function.
//
local obj_index = 0;
function OOP_IndexedHook( class )
	obj_index = obj_index + 1;
	return class .. obj_index;

end

